﻿/*
scripts_lib.sqf
*/
ACV_FNCT_Bombardement = {
    private ["_arr_mun","_duree","_rayon","_densite","_type_mun","_boom","_pos","_origin_x","_origin_y","_time_start","_x","_y"];
    _arr_mun = [
    	"SH_105_HE",
    	"SH_120_HE",
    	"SH_125_HE",
    	"SH_155_HE",
    	"R_57mm_HE",
    	"M_Sidewinder_AA",
    	"Bo_GBU12_LGB",
    	"AR_origin_y_R_227mm_HE",
    	"SH_120_HE"
    ];
    
    _duree		= 1 max (_this select 0);
    _rayon		= 10 max (_this select 2);
    _densite	= 0.042 max (_this select 3);
    _type_mun	= (_arr_mun select (0 max (_this select 4)));
    	
    _pos		= getPos (_this select 1);
    _origin_x	= (_pos select 0);
    _origin_y	= (_pos select 1);
    _time_start = time;
    
    while{(time-_time_start) < _duree} do {
    	sleep _densite;
    	_x = random _rayon;
    	_y = random _rayon;
    	if( (random 1) < 0.5) then {
    		_x = -_x;
    	};
    	if( (random 1) < 0.5) then {
    		_y = -_y;
    	};
    	_boom = _type_mun createvehicle [_origin_x + _x, _origin_y + _y, -0.1];
    	_boom setdammage 1;
    };
};

/*
Faire un champ de mine
@param1 position [x,y,z] du champs de mine
@param2 largeur du champs de mine
@param3 distance entre les mines
@param4 mines visibles (true) ou invisibles (false)

@return nombre de mines posées
*/
ACV_FNCT_MineField = {
	private ["_prof", "_x", "_y", "_n"];
	
	_pos		= _this select 0;
	_cote		= _this select 1;
	_distance	= _this select 2;
	_visible	= _this select 3;

	_x = 0;
	_y = 0;
	_n = 0;

	_pos = [(_pos select 0) - (_cote / 2) , (_pos select 1) - (_cote / 2) ,0];

	if (_visible) then{
		_prof = 0;
	}else{
		_prof = -0.1;
	};
	while {_y < _cote} do {
		while {_x < _cote} do {
			_r = 4 - (_distance / random 8);
			_r2 = 4 - (_distance / random 8);
			"Mine" createvehicle [(_pos select 0) + _x + _r, (_pos select 1) + _y + _r2, _prof];
			_x = _x	+ _distance;
			_n = _n + 1;
		};
		_x = 0;
		_y = _y + _distance;
	};
	_n;
};

ACV_FNCT_BroadcastMsg = {
	ACV_RADIO_MSG =_this select 0;
	[side player,"HQ"] sideChat ACV_RADIO_MSG;
	publicVariable "ACV_RADIO_MSG";
};

ACV_FNCT_BroadcastCode = {
	ACV_RADIO_CODE =_this select 0;
	call  compile ACV_RADIO_CODE;
	publicVariable "ACV_RADIO_CODE";
};